package ibase.marketingCampaign;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.utility.MailInfo;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;

public class MarketingCampaignPreSend extends ActionHandlerEJB {
	ValidatorEJB validatorEJB = new ValidatorEJB();
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();

	private static String readHtmlFile(String filePath) throws IOException {
		BaseLogger.log("3", null, null, "Calling readHtmlFile method");
		return new String(Files.readAllBytes(Paths.get(filePath)));
	}

	private String buildMailXMLStr(HashMap<String, Object> mailFormatDetails, UserInfoBean userInfo) {

		BaseLogger.log("2", null, null,
				"sendEmailToMe calling buildMailXMLStr-----------------[" + mailFormatDetails + "  ]");

		String mailXMLStr = "";

		// Fetch mail format details from the database
		String emailID = mailFormatDetails.get("SEND_TO").toString();
		BaseLogger.log("3", null, null, "buildMailXMLStr emailID [" + emailID + "]");

		/*
		 * Changes by Gagan B. on 08-OCT-24 to upload HTML to alfresco server in
		 * MAIL_FORMAT object and store the doc ID in MAIL_FORMAT.BODY_TEXT and use the
		 * same doc ID to retrieve the document and use it to display data in template
		 * and while sending the mail. -- START
		 */
		String getDocumentURL = CommonConstants.TOMCAT_HOME + "/ibase/rest/E12ExtService/getDocumentStream";

		Unirest.setTimeouts(0, 0);
		HttpResponse<String> getDocumentResponse = null;
		try {
			getDocumentResponse = Unirest.post(getDocumentURL).header("TOKEN_ID", userInfo.getTokenID())
					.field("DOC_ID", mailFormatDetails.get("BODY").toString()).asString();
		} catch (Exception e) {
			BaseLogger.log("3", null, null,
					"Exception in MktgCmpgnPreSend.buildXMLStr [" + E12GenericUtility.getStackTrace(e) + "]");

		}

		String statusText = getDocumentResponse.getStatusText();
		int statusCode = getDocumentResponse.getStatus();
		String responseString = getDocumentResponse.getBody().toString();

		BaseLogger.log("3", null, null, "Inside saveNewEmailTemplate getSelectedEmailXmlData [" + statusText + "]");
		BaseLogger.log("3", null, null, "Inside saveNewEmailTemplate getSelectedEmailXmlData [" + statusCode + "]");
		BaseLogger.log("3", null, null, "Inside saveNewEmailTemplate getSelectedEmailXmlData [" + responseString + "]");

//		String bodyFilePath = mailFormatDetails.get("BODY").toString();
		String body = "";
		try {
//			body = readHtmlFile(bodyFilePath);
			body = responseString;
		} catch (Exception e) {
			mailXMLStr = "NULLHTML";
			BaseLogger.log("3", null, null, "Exception in readHtmlFile method [" + e.getMessage() + "]");
			e.printStackTrace();
			return mailXMLStr;
		}
		/*
		 * Changes by Gagan B. on 08-OCT-24 to upload HTML to alfresco server in
		 * MAIL_FORMAT object and store the doc ID in MAIL_FORMAT.BODY_TEXT and use the
		 * same doc ID to retrieve the document and use it to display data in template
		 * and while sending the mail. -- END
		 */

		String formatCode = "";

		String system = mailFormatDetails.get("SUBJECT").toString();
		BaseLogger.log("3", null, null, "system [" + system + "]");

		String objName = "";
		String workDateApp = "";
		try {
			BaseLogger.log("2", null, null, "Inside try block method: buildMailXMLStr ---");

			mailXMLStr = "";

			mailXMLStr += "<ROOT>";
			mailXMLStr += "<TRANS_INFO>";
			mailXMLStr += "<OBJ_NAME><![CDATA[" + objName + "]]></OBJ_NAME>";
			mailXMLStr += "<REF_SER><![CDATA[]]></REF_SER>";
			mailXMLStr += "<REF_ID><![CDATA[" + workDateApp + "]]></REF_ID>";
			mailXMLStr += "<LINE_NO><![CDATA[1]]></LINE_NO>";
			mailXMLStr += "</TRANS_INFO>";
			mailXMLStr += "<EMAIL_TYPE><![CDATA[]]></EMAIL_TYPE>";
			mailXMLStr += "<ENTITY_CODE><![CDATA[]]></ENTITY_CODE>";
			mailXMLStr += "<FORMAT_CODE><![CDATA[" + formatCode + "]]></FORMAT_CODE>";
			mailXMLStr += "<LINK_ADDR><![CDATA[]]></LINK_ADDR>";
			mailXMLStr += "<TO_ADD><![CDATA[" + emailID + "]]></TO_ADD>";
			mailXMLStr += "<CC_ADD><![CDATA[" + mailFormatDetails.get("COPY_TO") + "]]></CC_ADD>";
			mailXMLStr += "<BCC_ADD><![CDATA[" + mailFormatDetails.get("BLIND_COPY") + "]]></BCC_ADD>";
			mailXMLStr += "<BODY_TEXT><![CDATA[" + body + "]]></BODY_TEXT>";
			mailXMLStr += "<SUBJECT><![CDATA[" + mailFormatDetails.get("SUBJECT") + "]]></SUBJECT>";

			mailXMLStr += "</ROOT>";

			System.out.println("mailXMLStr....::" + mailXMLStr);

		} catch (Exception e) {
			BaseLogger.log("0", null, null, "Exception from buildMailXMLStr [" + system + "]");
			e.printStackTrace();
		}

		return mailXMLStr;
	}

	public String sendEmail(String tranId, String xtraParams, String forcedFlag) throws Exception {
		String userId = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String formatCode = "";
		String subject = "";
		String bodyText = "";
		List<String> mailListName = new ArrayList<>();
		String retString = "";
		int batchCount = 0;
		DateFormat dtFormat = new SimpleDateFormat("dd-MMM-yy");
		java.util.Date date = Calendar.getInstance().getTime();
		String currentDate = dtFormat.format(date);
		List<String> mailList = new ArrayList<String>();
		UserInfoBean userInfo = getUserInfo();
		System.out.println("********************userinfo****************" + userInfo);
		try {
			conn = getConnection();
			userId = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			BaseLogger.log("3", null, null, "user id2 [" + userId + "]");
			BaseLogger.log("3", null, null, "tran id2 [" + tranId + "]");

			sql = "select mailing_list from mktg_campaign_det where campaign_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			while (rs.next()) {
				mailListName.add(rs.getString("mailing_list"));
				BaseLogger.log("3", null, null, "mail list name updated[" + mailListName + "]");

			}
			System.out.println(mailListName + "MailListName List");
			closeResources(rs, pstmt);

			// Used to get all email Id against the mail_list_id(campaign_template) from
			// mailing_list_det and store it in Logs table
			for(int i = 0; i < mailListName.size() ; i++) {
				sql = "select email_id from mailing_list_det where mail_list_id = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, mailListName.get(i));
				rs = pstmt.executeQuery();
				while (rs.next()) {
					mailList.add(rs.getString("email_id"));
				}
				closeResources(rs, pstmt);
				BaseLogger.log("3", null, null, "mail list updated[" + mailList + "]");
			}
			
			// To check weather email Id present or not in mailing_list
//			if (mailList.isEmpty()) {
//				retString = itmDBAccessEJB.getErrorString("", "NMAILIST", "", "", conn);
//				return retString;
//			}
			conn.setAutoCommit(false);
			// To add entries in mktg_cmpaign_log table
			for (String emilId : mailList) {
				sql = "insert into mktg_campaign_log (campaign_id,email_id,status,status_date) values (?,?,'N',?)";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				pstmt.setString(2, emilId);
				pstmt.setString(3, currentDate);

				BaseLogger.log("3", null, null, "email for insert [" + emilId + "]");

				rs = pstmt.executeQuery();
				closeResources(rs, pstmt);
			}
			conn.commit();

			sql = "select campaign_template,batch_count from mktg_campaign where campaign_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				formatCode = rs.getString("campaign_template");
				batchCount = rs.getInt("batch_count");
			}
			closeResources(rs, pstmt);
			BaseLogger.log("3", null, null, "format code [" + formatCode + "]");

			sql = "select subject,body_text from mail_format where format_code = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, formatCode);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				subject = rs.getString("subject");
				bodyText = rs.getString("body_text");
			}
			closeResources(rs, pstmt);
			BaseLogger.log("3", null, null, "subject [" + subject + "]");
			BaseLogger.log("3", null, null, "body text [" + bodyText + "]");

			// Calling method to send mail according to batch count
			retString = sendEmailWithBatchCount(mailList, batchCount, subject, bodyText, userInfo, tranId);

		} catch (Exception e) {
			System.out
					.println("Exception :MarketingCampaignPreSend :sendMail(Document,String):" + e.getMessage() + ":");
			e.printStackTrace();
		} finally {
			closeResources(rs, pstmt, conn);
		}
		return retString;

	}

	public List<String> getUpdatedEmail(String tranId, int batchCount) {
		List<String> mailListForMailSend = new ArrayList<>();
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";

		try {
			conn = getConnection();
			conn.setAutoCommit(false);

			// Get email IDs with status 'N'
			sql = "SELECT email_id FROM mktg_campaign_log WHERE status = 'N' AND campaign_id = ? FETCH NEXT ? ROWS ONLY";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			pstmt.setInt(2, batchCount);
			rs = pstmt.executeQuery();
			while (rs.next()) {
				mailListForMailSend.add(rs.getString("email_id"));
			}
			BaseLogger.log("3", null, null, "Mail list for mail sending [" + mailListForMailSend + "]");
			conn.commit();
		} catch (Exception e) {
			e.printStackTrace();
			BaseLogger.log("0", null, null, "Exception in getUpdatedEmail: " + e.getMessage());
			if (conn != null) {
				try {
					conn.rollback();
					BaseLogger.log("0", null, null, "Transaction rolled back due to exception.");
				} catch (SQLException se) {
					se.printStackTrace();
				}
			}
		} finally {
			closeResources(rs, pstmt, conn);
		}
		return mailListForMailSend;
	}

	public String sendEmailWithBatchCount(List<String> mailList2, int batchCount, String subject, String bodyText,
			UserInfoBean userInfo, String tranId) {
		BaseLogger.log("3", null, null, "sendEmailWithBatchCount method calling [" + batchCount + "]");

		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String fromEmailId = "", retString = "";
		String status = "";
		String errMsg = "";
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		List<String> mailListForMailSend;
		boolean updateFlag = false;

		try {
			conn = getConnection();
			conn.setAutoCommit(false); // Begin transaction

			while (true) {
				mailListForMailSend = getUpdatedEmail(tranId, batchCount);

				if (mailListForMailSend.isEmpty()) {
					updateFlag = true;
					break;
				}

				int totalMails = mailListForMailSend.size();
				int totalBatches = (int) Math.ceil((double) totalMails / batchCount);

				for (int i = 0; i < totalBatches; i++) {
					int start = i * batchCount;
					int end = Math.min(start + batchCount, totalMails);
					List<String> batchList = mailListForMailSend.subList(start, end);

					for (String emailId : batchList) {
						BaseLogger.log("3", null, null, "Single emailId [" + emailId + "]");

						HashMap<String, Object> mailFormatDetails = new HashMap<>();
						mailFormatDetails.put("SEND_TO", emailId);
						mailFormatDetails.put("MAIL_SERVER", "192.168.137.1");
						mailFormatDetails.put("SUBJECT", subject);
						mailFormatDetails.put("BODY", bodyText);

						EMail email = new EMail();
						email.setMailFrom(mailFormatDetails.get("MAIL_SERVER").toString());
						BaseLogger.log("3", null, null, "Mail from [" + fromEmailId + "]");

						String mailXMLStr = buildMailXMLStr(mailFormatDetails, userInfo);
						if (mailXMLStr.equals("NULLHTML")) {
							BaseLogger.log("3", null, null, "mailXMLStr string[" + mailXMLStr + "]");
							retString = itmDBAccessEJB.getErrorString("", mailXMLStr, "", "", conn);
							return retString;
						}
						String emailStatus;
						try {
							emailStatus = email.sendMail(mailXMLStr, "ITM", userInfo);
							BaseLogger.log("3", null, null, "Email status for [" + emailId + "]: " + emailStatus);
							status = "S";
							errMsg = "None";
						} catch (Exception e) {
							BaseLogger.log("3", null, null,
									"Error sending email to [" + emailId + "]: " + e.getMessage());
							status = "E";
							errMsg = e.getMessage();
						}
						// Update the log
						sql = "UPDATE mktg_campaign_log SET status = ?, err_msg = ? WHERE email_id = ? AND campaign_id = ?";
						try (PreparedStatement updatePstmt = conn.prepareStatement(sql)) {
							updatePstmt.setString(1, status);
							updatePstmt.setString(2, errMsg);
							updatePstmt.setString(3, emailId);
							updatePstmt.setString(4, tranId);
							int affectedRows = updatePstmt.executeUpdate();
							BaseLogger.log("3", null, null,
									"Rows affected by update for emailId [" + emailId + "]: " + affectedRows);
						} catch (SQLException e) {
							BaseLogger.log("3", null, null,
									"Error updating log for emailId [" + emailId + "]: " + e.getMessage());
							conn.rollback();
						}
						conn.commit();
					}
				}

			}
			if (updateFlag) {
				retString = itmDBAccessEJB.getErrorString("", "VTMAILSUCC", "", "", conn);
				return retString;
			}
		} catch (Exception e) {
			e.printStackTrace();
			BaseLogger.log("0", null, null, "Exception during email processing: " + e.getMessage());
			if (conn != null) {
				try {
					conn.rollback();
					BaseLogger.log("0", null, null, "Transaction rolled back due to exception.");
				} catch (SQLException se) {
					se.printStackTrace();
				}
			}
		} finally {
			closeResources(rs, pstmt, conn);
		}
		return retString;
	}

	public String sendEmailToMe(String tranId, String xtraParams, String forcedFlag) {
		String userId = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String userEmail = "";
		String formatCode = "";
		String subject = "";
		String bodyText = "", msg = "";
		// boolean updateFlag = false;
		String retString = "";

		UserInfoBean userInfo = getUserInfo();
		System.out.println("********************userinfo****************" + userInfo);
		System.out.println("********************xtraParams***********[" + xtraParams + "]");
		try {
			conn = getConnection();
//			userId = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			userId = userInfo.getLoginCode();
			BaseLogger.log("3", null, null, "user id [" + userId + "]");
			BaseLogger.log("3", null, null, "tran id [" + tranId + "]");

			sql = "select email_id from users where code = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, userId);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				userEmail = rs.getString("email_id");
			}
			closeResources(rs, pstmt);
			// Check weather email id present or not against loged in user
			if (userEmail == null) {
				BaseLogger.log("3", null, null, "In null condition [" + userEmail + "]");
				retString = itmDBAccessEJB.getErrorString("", "NULEMAILID", "", "", conn);
				return retString;
			}
			BaseLogger.log("3", null, null, "user email [" + userEmail + "]");

			sql = "select campaign_template from mktg_campaign where campaign_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				formatCode = rs.getString("campaign_template");
			}
			closeResources(rs, pstmt);
			BaseLogger.log("3", null, null, "format code [" + formatCode + "]");

			sql = "select subject,body_text from mail_format where format_code = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, formatCode);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				subject = rs.getString("subject");
				bodyText = rs.getString("body_text");
			}
			closeResources(rs, pstmt);
			BaseLogger.log("3", null, null, "subject [" + subject + "]");
			BaseLogger.log("3", null, null, "body text [" + bodyText + "]");

			HashMap<String, Object> mailFormatDetails = new HashMap<>();
			mailFormatDetails.put("SEND_TO", userEmail);
			mailFormatDetails.put("MAIL_SERVER", "192.168.137.1");
			mailFormatDetails.put("SUBJECT", subject);
			mailFormatDetails.put("BODY", bodyText);
			EMail email = new EMail();
			email.setMailFrom(mailFormatDetails.get("MAIL_SERVER").toString()); // Set the email sender address
			System.out.println("getMailFrom1....::" + email.getMailFrom());
			String mailXMLStr = buildMailXMLStr(mailFormatDetails, userInfo);
			if (mailXMLStr.equals("NULLHTML")) {
				BaseLogger.log("3", null, null, "mailXMLStr string[" + mailXMLStr + "]");
				retString = itmDBAccessEJB.getErrorString("", mailXMLStr, "", "", conn);
				return retString;
			}
			try {
				BaseLogger.log("3", null, null, "Before sendMail method calling");
				String emailStatus = email.sendMail(mailXMLStr, "ITM", userInfo);
				// msg = emailStatus.equals("S") ? "VTMAILSUCC" : "MAILFAILED";
				BaseLogger.log("3", null, null, "Email Statsus[" + emailStatus + "]");
				retString = itmDBAccessEJB.getErrorString("", "VTMAILSUCC", "", "", conn);
			} catch (Exception e) {
				retString = itmDBAccessEJB.getErrorString("", "MAILFAILED", "", "", conn);
				System.out.println("Exception in senMail method" + e.getMessage() + ":");
				e.printStackTrace();
			}

		} catch (Exception e) {
			System.out.println("Exception in EmailSendToMe method" + e.getMessage() + ":");
			e.printStackTrace();
		} finally {
			closeResources(rs, pstmt, conn);
		}
		return retString;

	}

	private void closeResources(ResultSet rs, PreparedStatement pstmt, Connection conn) {
		if (rs != null) {
			try {
				rs.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
		}
		if (pstmt != null) {
			try {
				pstmt.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
		}
		if (conn != null) {
			try {
				conn.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
		}
	}

	private void closeResources(ResultSet rs, PreparedStatement pstmt) {
		if (rs != null) {
			try {
				rs.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
		}
		if (pstmt != null) {
			try {
				pstmt.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
		}
	}

}